/*****************************************************************************
*  LPC43xx SCT demo program
*
*  Use SCT timer to generate a two-channel double-edge controlled PWM
*  intended for use as a complementary PWM pair with dead-time control
*  SCT_IN0 (pin P2_4) is used as ABORT
*  SCT_OUT0 (pin P2_8) is PWM1
*  SCT_OUT1 (pin P2_7) is PWM2
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

void SCT_IRQHandler(void)
{
    LPC_SCT->CTRL_L |=  (1 << 3);                      // clear the L counter
    LPC_SCT->CTRL_L &= ~(1 << 1);                      // start the L counter

    LPC_SCT->EVFLAG  = (1 << 1);                       // clear event 1 interrupt flag
}

int main (void)
{
    SystemCoreClockUpdate ();                          // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);              // enable SCT clock in CCU1 

    MCB4300_Init();                                    // Initialize MCB4300 board stuff
    SCT_Init();                                        // Initialize SCT

    while (1)                                          // loop forever
    {
    }
}
